import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:hive/hive.dart';
import 'package:wordpress_app/models/article.dart';
import 'package:wordpress_app/services/app_service.dart';
import 'package:wordpress_app/utils/cached_image.dart';
import 'package:wordpress_app/utils/next_screen.dart';
import 'package:wordpress_app/widgets/bookmark_icon.dart';
import 'package:wordpress_app/widgets/video_icon.dart';
import '../blocs/config_bloc.dart';
import '../constants/constant.dart';

//small card with right sight image
class Card1 extends ConsumerWidget {
  final Article article;
  final String heroTag;
  const Card1({
    super.key,
    required this.article,
    required this.heroTag,
  });

  @override
  Widget build(BuildContext context, WidgetRef ref) {
    final bookmarkedList = Hive.box(Constants.bookmarkTag);
    final configs = ref.read(configBlocProvider).configs!;
    final bool showDateTime = configs.showDateTime;

    return InkWell(
        child: Container(
            decoration: BoxDecoration(
              color: Theme.of(context).cardColor,
              borderRadius: BorderRadius.circular(5),
            ),
            child: Column(
              children: <Widget>[
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Flexible(
                      flex: 5,
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: <Widget>[
                          Container(
                            margin: const EdgeInsets.symmetric(vertical: 10),
                            padding: const EdgeInsets.symmetric(
                              horizontal: 12,
                              vertical: 3,
                            ),
                            decoration: BoxDecoration(
                              color: Colors.green,
                              borderRadius: BorderRadius.circular(30),
                            ),
                            child: Text(
                              article.category.toString(),
                              style: Theme.of(context)
                                  .textTheme
                                  .labelSmall
                                  ?.copyWith(
                                      fontWeight: FontWeight.w600,
                                      color: Colors.white),
                            ),
                          ),
                          Text(
                            AppService.getNormalText(article.title!),
                            style: Theme.of(context)
                                .textTheme
                                .titleMedium
                                ?.copyWith(
                                    fontWeight: FontWeight.w600, fontSize: 17),
                            maxLines: 3,
                            overflow: TextOverflow.ellipsis,
                          ),
                          const SizedBox(
                            height: 10,
                          ),
                        ],
                      ),
                    ),
                    const SizedBox(
                      width: 10,
                    ),
                    Hero(
                      tag: heroTag,
                      child: Stack(
                        alignment: Alignment.center,
                        children: [
                          Container(
                            height: 120,
                            width: 120,
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(10),
                            ),
                            child: CustomCacheImage(
                                imageUrl: article.image, radius: 5.0),
                          ),
                          VideoIcon(
                            article: article,
                            iconSize: 40,
                          )
                        ],
                      ),
                    )
                  ],
                ),
                Visibility(
                  visible: showDateTime,
                  child: Row(
                    children: [
                      Icon(
                        CupertinoIcons.time,
                        size: 18,
                        color: Theme.of(context).colorScheme.onSurfaceVariant,
                      ),
                      const SizedBox(
                        width: 3,
                      ),
                      Text(
                        AppService.getTime(article.date!, context),
                        style: Theme.of(context).textTheme.bodyMedium?.copyWith(
                            color: Theme.of(context).colorScheme.secondary,
                            fontWeight: FontWeight.w400),
                      ),
                      const Spacer(),
                      BookmarkIcon(
                        bookmarkedList: bookmarkedList,
                        article: article,
                        iconSize: 18,
                      )
                    ],
                  ),
                ),
              ],
            )),
        onTap: () =>
            navigateToDetailsScreen(context, article, heroTag, configs));
  }
}
